class Timers {
  timeouts = [];
  intervals = [];
  rafs = [];
  /** @public */
  setTimeout(handler, timeout, ...args) {
    const id = window.setTimeout(handler, timeout, args);
    this.timeouts.push(id);
    return id;
  }
  /** @public */
  setInterval(handler, timeout, ...args) {
    const id = window.setInterval(handler, timeout, args);
    this.intervals.push(id);
    return id;
  }
  /** @public */
  requestAnimationFrame(callback) {
    const id = window.requestAnimationFrame(callback);
    this.rafs.push(id);
    return id;
  }
  /** @public */
  dispose() {
    this.timeouts.forEach((id) => clearTimeout(id));
    this.intervals.forEach((id) => clearInterval(id));
    this.rafs.forEach((id) => cancelAnimationFrame(id));
    this.timeouts.length = 0;
    this.intervals.length = 0;
    this.rafs.length = 0;
  }
}
export {
  Timers
};
//# sourceMappingURL=timers.mjs.map
